<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # p0wersurge.com presents a fresh release                          # ||
|| # ---------------------------------------------------------------- # ||
|| # CometChat 4                                                      # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

include dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR."modules.php";
include dirname(__FILE__).DIRECTORY_SEPARATOR."config.php";

if (file_exists(dirname(__FILE__).'/data.php')) {

	include dirname(__FILE__).'/data.php';
	$games = unserialize(trim($games));

} else {

	$url = "http://www.tictacti.com/feed/games.feed?publisherId=k4xo3eH3wNI%3d&format=json";

	$ch = curl_init();
	$target = $url;
	curl_setopt($ch, CURLOPT_URL, $target);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$data = curl_exec($ch);
	$data = json_decode($data);

	$games = array();

	foreach ($data->feed->games as $game) {
		$title = $game->title;
		$thumbnail = $game->summary->div->a->img->{'@src'};
		$category = 'featured';

		if (!empty($game->category)) {
			foreach ($game->category as $cat) {
				if (!empty($cat) && is_string($cat)) { $category = $cat; break;}
				if (!empty($cat->{'@term'}) && is_string($cat->{'@term'})) { $category = $cat->{'@term'}; break;}
			}
		}
		
		foreach ($game->summary->div->{'dl'}->dd as $info) {
			if (!empty($info->{'@class'}) && $info->{'@class'} == 'width') { $width = $info->{'#text'}; }
			if (!empty($info->{'@class'}) && $info->{'@class'} == 'height') { $height = $info->{'#text'}; }
			if (!empty($info->code) && !empty($info->code->{'#text'}) && $info->code->{'@class'} == 'iframe') { $code = $info->code->{'#text'}; }
		}

		if (!empty($title) && !empty($thumbnail) && !empty($category) && !empty($width) && !empty($height) && !empty($code)) {
			if (!empty($category) && empty($games[$category])) {
				$games[$category] = array();
			}
			
			array_push($games[$category], array("title" => $title, "thumbnail" => $thumbnail, "width" => $width, "height" => $height, "code" => $code));

		}
	}

	$store = serialize($games);
	$fh = fopen(dirname(__FILE__).'/data.php', 'w');
	fwrite($fh, '<?php'."\r\n".'$games = <<<EOD'."\r\n".$store."\r\n".'EOD;'."\r\n".'?>');
	fclose($fh);
}


if (!empty($_GET['get']) && $_GET['get'] == 'categories') {
	$categories = array();
	foreach ($games as $category => $game) {
		$categories[] = array('display_name' => ucwords($category), 'name' => $category, 'num_games' => 0);
	}
	$data = array('categories' => $categories);
	echo json_encode($data);
} else if (!empty($_GET['get'])) {
	$category = $_GET['get'];
	$games = $games[$category];
	
	$g = array();

	foreach ($games as $game) {
		$g[] = array('display_name' => $game['title'], 'thumb_100x100' => $game['thumbnail'], 'width' => $game['width'], 'height' => $game['height'], 'embed_code' => $game['code'], 'description' => '');
	}

	$data = array('games' => $g);
	echo json_encode($data);
}